#!/bin/sh

# This script is made available under the GPLv2 terms.
# Written 2008 by Daniel Cervera, dc11ab (at) gmail (dot) com
# With kind help from lundman and Kalle Andersson
# Version 1.5
# This enables autostart of the llink media server on Synology NAS.
# Look at lundman.net or networkedmediatank.com for more information.
#
# If you want to use another skin than the default Aquarius_720, add
#  -f <skin conf filename>
# between the ./llink and the two pipes || in line 25, example: 
# ... && ./llink -f jukebox.conf || ... 

# Make sure we have a clean start
if [ "$1" = "stop" ]; then
       killall llink
   exit 0
fi

# Make sure this is the correct path to llink:
llink="/volume1/llink-2.0.6-syno_x06/src/llink"

# Check if llink exist; if so then run it, else say that it didn't work:
cd  `dirname $llink` && ./llink || echo "$llink or its directory doesn't exist, and check permissions!"

# End of script
