#!/bin/sh 

# Clean up PATH for security reasons.
PATH=/bin:/usr/bin

# Work out where we are run from.
pwd=$0;
# "/opt/sybhttpd/localhost.drives/HARD_DISK/llink-installer.cgi"
urlpwd=`echo $pwd | sed 's#/opt/sybhttpd/localhost.drives/\(.*\)/.*$#\1#g'`
# "HARD_DISK"
exename=`echo $pwd | sed 's#.*/\([^/]*\)$#\1#g'`
# "llink-installer.cgi"


# Defines used for this version
INSTALL="/opt/sybhttpd/localhost.drives/$urlpwd/busybox26"
DEST="/opt/sybhttpd/localhost.drives/HARD_DISK/bin"
USBDIR="/opt/sybhttpd/localhost.drives/$urlpwd"
STARTER="/opt/sybhttpd/localhost.drives/HARD_DISK/start_app.sh"


###############################################################
# Define the functions we will call.
# No changes should be needed from here on
###############################################################
MARKER="#M_A_R_K_E_R_do_not_remove_me"
FTPSERVER="/mnt/syb8634/etc/ftpserver.sh"

start_html()
{
	echo "Content-Type: text/html"
	echo ""
	cat <<EOF
<html>
<head>
<title>
telnet-installer
</title>
</head>
<body>

<h2>
EOF

}

# Send the closing HTML
end_html() 
{ 
  cat <<EOF
</h2>
</body>
</html>
EOF
  
}


# Do some minor sanity checks that the HDD is mounted.
check_has_hdd()
{

  /bin/mount | /bin/grep -q /opt/sybhttpd/localhost.drives/HARD_DISK
  if [ $? != 0 ]; then
    echo "Sorry, but you do not appear to have HARD_DISK mounted<br>" 
    end_html
    exit 0
  fi

}


autostart_setup()
{

  # Insert code here to make it auto-start
	if [ -f "$STARTER" ]; then
		echo "Found user community agreed on startup file...<br>"
	else
		# Create the file. Then do the scary part of making it be
		# executed at boot time.
		echo "Created user community startup file...<br>"
		cat > "$STARTER" <<EOF
#!/bin/sh
#

$MARKER

exit 0
EOF
		chmod 755 "$STARTER"
     fi

		# Check if it is already called from ftpserver.sh
	grep -q "$STARTER" "$FTPSERVER"
	if [ $? != 0 ]; then
		echo "Installer starter<br>"

		cp "$FTPSERVER" "$FTPSERVER.backup"
		
		rm -f /tmp/.ftpserver.tmp /tmp/.found
		IFS=""
		cat "$FTPSERVER" | while read line
		  do
		  echo "$line" >> /tmp/.ftpserver.tmp
		  if [ x"$line" == x"start() {" ]; then
			  echo "      $STARTER &" >> /tmp/.ftpserver.tmp
			  touch /tmp/.found
		  fi
		done
		
		if [ -f /tmp/.found ]; then
			cat < /tmp/.ftpserver.tmp > "$FTPSERVER"
			chmod 774 "$FTPSERVER"
		fi
		rm -f /tmp/.ftpserver.tmp /tmp/.found
	fi
	
}



autostart_add()
{
	
    /bin/cat "$STARTER" | /bin/grep -q "telnetd"
    if [ $? == 0 ]; then
		echo "telnetd already set to start on boot, skipping <br>"
    else
		echo "Adding telnetd to community agreed startup script.<br>"
		
		rm -f /tmp/.starter.tmp
		IFS=""
		cat "$STARTER" | while read line 
		do
		  echo "$line" >> /tmp/.starter.tmp
		  if [ x"$line" == x"$MARKER" ]; then
			  echo "cd ${DEST}/ && ./telnetd -l /bin/sh &" >> /tmp/.starter.tmp
		  fi
		done
		cat < /tmp/.starter.tmp > "$STARTER"
		chmod 755 "$STARTER"
		rm -f /tmp/.starter.tmp
    fi

}


kill_llink()
{

	echo ""

}

start_llink()
{

  #
	# Run busybox26 since if this is from USB, there are no symlinks
    ./busybox26 telnetd -l /bin/sh &

	if [ $? != 0 ]; then
		echo "Sorry, it appears starting telnetd failed.<br>"
	fi

	# So, for some reason uClibc has a weird way to detach from tty
	# so as a hack, we kill the wget that hangs forever.
	sleep 1
    pids=`pidof wget`
	if [ x"$pids" != x"" ]; then
		kill $pids
	fi

}


# Install program on HDD
install_harddisk()
{ 
	check_has_hdd

	# find a name
	set -- $INSTALL
	INSTA="$1"

 # We expect to find tarball next to this script.
	if [ ! -f "$INSTA" ]; then
		echo "Unable to read<br>"
		echo "$INSTALL<br>"
		echo "Please place binary next to<br>"
		echo "$exename<br>"
		echo "script, and try again.<br>"
		exit 0;
	fi

	echo "Installing to HARD_DISK...<br>"
  # We make sure that HARD_DISK/Apps/
	mkdir -p "$DEST"
	chmod 777 "$DEST"
	
	# Actually copy the data now.
	cp -f "$INSTA" "$DEST/"

	if [ $? != 0 ]; then
		echo "Sorry, it appears that cp returned an error.<br>"
		exit 0;
	fi
	
	chmod 755 "$DEST/busybox26"

	# Make it so they can edit files easily.
	cd "$DEST"
    for i in ftpget ftpput hexdump md5sum more nc nohup printf telnet telnetd traceroute vi 
    do
      ln -s busybox26 $i 2>1 > /dev/null
    done

	# Check auto starter
	autostart_setup

	autostart_add

	
	echo "Starting telnetd ... <br>"

	kill_llink

	cd "$DEST/" && start_llink


	echo "Success..<br>"
	echo "<a href=\"http://127.0.0.1:8883/start.cgi?list\">Sources</a>"
  # Remove the tarball
	rm -f "$INSTA"

	exit 0;
}



usbrun()
{

	if [ -d "$USBDIR" ]; then
        chmod 755 "$INSTALL"
		cd "$USBDIR" && start_llink
    else
		echo "Unable to find directory.<br>"
		echo "Make sure the directory 'busybox26' is next to this install script<br>"
		exit 0
	fi

	exit 0

}


tmpinstall()
{

	# find a name
	set -- $INSTALL
	INSTA="$1"

 # We expect to find tarball next to this script.
	if [ ! -f "$INSTA" ]; then
		echo "Unable to read<br>"
		echo "$INSTALL<br>"
		echo "Please place binary next to<br>"
		echo "$exename<br>"
		echo "script, and try again.<br>"
		exit 0;
	fi

	if [ -f "$INSTA" ]; then
		echo "Found program...<br>"
    else
		echo "Unable to find busybox26 program.<br>"
		echo "Make sure the file 'busybox26' is next to this install script<br>"
		exit 0
	fi

	cp -f "$INSTA" "/tmp/"

	if [ $? != 0 ]; then
		echo "Sorry, it appears that cp returned an error.<br>"
		exit 0;
	fi
	
	chmod 755 "/tmp/busybox26"

    cd "/tmp/" && start_llink

	exit 0

}


#########################################################################
#
# Main function begins here
#
#########################################################################

start_html


# check if we were run without arguments, if so display "menu"
case "$1" in
  install)
      install_harddisk;;
  usbrun)
      usbrun;;
  tmpinstall)
      tmpinstall;;
esac


cat <<EOF
Welcome to telnet installer.<br>
We are currently running from:<br>
$urlpwd/$exename<br>
<br>

<a href="http://localhost.drives:8883/$urlpwd/$exename?install">
Install to HARD_DISK ?
</a>

<br>

<a href="http://localhost.drives:8883/$urlpwd/$exename?usbrun">
Run from USB ($urlpwd) (Removing USB would be bad)
</a>

<br>                                                                       

<a href="http://localhost.drives:8883/$urlpwd/$exename?tmpinstall"> 
Install to /tmp/ (Removing USB is ok) 
</a> 

EOF

end_html

exit 0


